import { Toast, showToast } from "@raycast/api";
import { reindexWorkspace } from "./lib/spore";

export default async function Command() {
  try {
    await showToast({ style: Toast.Style.Animated, title: "Reindexing..." });
    await reindexWorkspace();
    await showToast({ style: Toast.Style.Success, title: "Index updated" });
  } catch (error) {
    await showToast({ style: Toast.Style.Failure, title: "Reindex failed", message: String(error) });
  }
}
