# Spore for Raycast

<p align="center">
  <img src="assets/command-icon.png" alt="Spore Icon" width="128" height="128">
</p>

Run and manage your [Spore](https://spore.bluemelon.io) prompts directly from Raycast.

## Features

- **Run Prompt** - Search and execute Spore prompts with a dynamic input form
- **Reindex Workspace** - Rebuild your Spore prompt index on demand

## Prerequisites

Before using this extension, you need:

1. **Spore app or CLI installed** - The extension calls Spore CLI commands under the hood
   - Download from [spore.bluemelon.io/download](https://spore.bluemelon.io/download)
   - Or build from source: `swift build` in the Spore repository

2. **A Spore workspace** - Create `.spore.md` promptfiles in `~/Documents/Spore/` (default) or a custom directory

## Installation

### Option 1: Import Extension (Recommended)

1. Download the latest release from [spore.bluemelon.io/download](https://spore.bluemelon.io/download)
2. Unzip the downloaded file
3. In Raycast, open the Command Palette and search for **"Import Extension"**
4. Select the unzipped `spore-raycast` folder
5. Done! Search for "Spore" in Raycast to get started

### Option 2: Build from Source

```bash
# Clone the repository
git clone https://github.com/your-username/spore.git
cd spore/Raycast

# Install dependencies
npm install

# Build the extension
npm run build

# Import into Raycast
# Open Raycast → Import Extension → Select this folder
```

## Configuration

Open Raycast Preferences → Extensions → Spore to configure:

| Setting | Description | Required |
|---------|-------------|----------|
| **Spore CLI Path** | Override auto-detection if needed (e.g., `/Applications/Spore.app/Contents/MacOS/spore`) | No |
| **Workspace Path** | Custom Spore workspace directory | No |
| **OpenAI API Key** | Your OpenAI API key for running prompts | No |
| **OpenAI Model** | Override the model (e.g., `gpt-4o`, `gpt-4o-mini`) | No |
| **OpenAI Base URL** | Custom API endpoint for proxies | No |

### CLI Discovery

The extension automatically searches for the Spore CLI in these locations (in order):

1. Custom path set in preferences
2. `spore` command on your `$PATH`
3. `/opt/homebrew/bin/spore` (Homebrew on Apple Silicon)
4. `/usr/local/bin/spore` (Homebrew on Intel)
5. `/Applications/Spore.app/Contents/MacOS/spore`
6. `~/Applications/Spore.app/Contents/MacOS/spore`
7. Swift build directories (for development)

## Commands

### Run Prompt

1. Launch Raycast and search for **"Run Prompt"**
2. Browse or search your prompts
3. Select a prompt to open the input form
4. Fill in the required inputs
5. Press Enter to run
6. Output is automatically copied to your clipboard

### Reindex Workspace

Rebuilds the Spore prompt index. Useful after adding or modifying `.spore.md` files.

## Troubleshooting

### "Spore CLI not found"

- Make sure Spore is installed
- Set the **Spore CLI Path** in extension preferences to the full path of the `spore` binary

### "Failed to load prompts"

- Ensure your workspace contains valid `.spore.md` files
- Try running the **Reindex Workspace** command
- Check that the **Workspace Path** is correct in preferences

### OpenAI errors

- Verify your **OpenAI API Key** is valid
- Check you have credits/quota remaining
- Try setting a specific **OpenAI Model** in preferences

## Support

- 📖 [Spore Documentation](https://spore.bluemelon.io)
- 🐛 [Report Issues](https://github.com/your-username/spore/issues)
- 💬 [Discussions](https://github.com/your-username/spore/discussions)

## License

MIT License - see [LICENSE](../LICENSE) for details.
